/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.RemotePluginFile;

public class RemotePlugin {
    private String pluginKey;
    private RemotePluginFile file = null;

    public RemotePlugin(String pluginKey) {
        this.pluginKey = pluginKey;
    }

    public static RemotePlugin create(PluginInfo pluginInfo) {
        RemotePlugin result = new RemotePlugin(pluginInfo.getKey());
        result.setFile(pluginInfo.getNonNullJarFile());
        return result;
    }

    public static RemotePlugin unmarshal(String row) {
        String[] fields = StringUtils.split(row, ",");
        RemotePlugin result = new RemotePlugin(fields[0]);
        if (fields.length >= 2) {
            String[] nameAndHash = StringUtils.split(fields[1], "|");
            result.setFile(nameAndHash[0], nameAndHash[1]);
        }
        return result;
    }

    public String marshal() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pluginKey);
        sb.append(",").append(this.file.getFilename()).append("|").append(this.file.getHash());
        return sb.toString();
    }

    public String getKey() {
        return this.pluginKey;
    }

    public RemotePlugin setFile(String filename, String hash) {
        this.file = new RemotePluginFile(filename, hash);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RemotePlugin setFile(File f) {
        try (FileInputStream fis = new FileInputStream(f);){
            RemotePlugin remotePlugin = this.setFile(f.getName(), DigestUtils.md5Hex(fis));
            return remotePlugin;
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to compute hash", e);
        }
    }

    public RemotePluginFile file() {
        return this.file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemotePlugin that = (RemotePlugin)o;
        return this.pluginKey.equals(that.pluginKey);
    }

    public int hashCode() {
        return this.pluginKey.hashCode();
    }
}

